/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
#include "derivative.h"
#include "Jm128_Bootloader.h" 

void _Entry(void);
extern asm void _startup(void);




// USB Standard command
#define mGET_STATUS   0  //LPP
#define mSET_ADDR     5
#define mGET_DESC     6
#define mSET_CFG      9

// USB ICP Vendor Commands
#define mPROGRAM			0x81
#define mSECTOR_ERASE	0x82
#define mVERIFY       0x87
#define mGET_RESULT		0x8F

// Descriptor Types
#define mDESC_DEV     0x01
#define mDESC_CFG     0x02
#define mDESC_STR     0x03

// Endpoint0 Token define
#define mEP0_OUT      0x00
#define mEP0_IN       0x08
#define mSETUP_TOKEN  0b00001101


#define mMCU      0x00
#define mUDATA0   0x88
#define mUDATA1   0xC8

#define mEP0_BUFF_SIZE   64


enum {
  mICP_WAIT,     
  mICP_TX,       
  mICP_RX       
};



typedef union _tBDT_STAT
{
    byte _byte;
    struct{
        byte  :2;                    // bit 0-1 reserved
        byte BSTALL:1;              // BDT stall'
        byte DTS:1;                 //Data Toggle Synch Enable
        byte NINC:1;                //Address Increment Disable
        byte KEEP:1;                //BD Keep Enable
        byte DATA:1;                //Data Toggle Synch Value
        byte UOWN:1;                //USB Ownership   
    }CtlBit;
    
  
    struct{
        byte    :2;
        byte PID:4;                 //Packet Identifier
        byte    :2;
        
    }RecPid;
} tBDT_STAT;                            //Buffer Descriptor Status Register

typedef struct _tBDT_ADDR
{
  byte  addr0:8;
  byte  addr1:8;
  byte  addr2:8;
  byte  addr3:8;
}tBDT_ADDR;


typedef struct _tICP_BDT
{
  tBDT_STAT BDT_Stat;
  byte      Rev;
  byte      Cnt;
  byte      Rev2;
  byte      Addr0;
  byte      Addr1;
  byte      Addr2;
  byte      Addr3;
}tICP_BDT;


typedef struct _tUSB_Setup {
       byte bmRequestType;
       byte bRequest;
       byte wValue_l;
       byte wValue_h;
       byte wIndex_l;
       byte wIndex_h;
       byte wLength_l;
       byte wLength_h;
}tUSB_Setup;

typedef struct _tICPSTR
{
  byte Byte;
  struct {
    byte AddrPend     :1;                                      
    byte none         :1;                                       
    byte Prog         :1;                                       
    byte Verify       :1;                                      
    byte none2        :1;                                       
    byte none3        :1;
    byte none4        :1;
    byte none5        :1;                                      
  } Bits;
}tICPSTR;

tICPSTR _ICP_VAR;
#define ICP_VAR               _ICP_VAR.Byte
#define ICP_AddrPend          _ICP_VAR.Bits.AddrPend
#define ICP_Prog              _ICP_VAR.Bits.Prog
#define ICP_Verify            _ICP_VAR.Bits.Verify



tICP_BDT EP0Rx[2]@0x00803E00;
tICP_BDT EP0Tx[2]@0x00803E10;

tUSB_Setup Setup_Pkt@0x00803E20;

byte ICP_OUT_Data @0x00803E30;
byte ICP_IN_Data@0x00803E80;

byte *pEP0IN_Data;
byte vEP0IN_DataCnt;

byte vEP0RxData;          // data0/1 toggle
byte vEP0TxData;          // data0/1 toggle
byte vEP0RxBuf;           // odd buf and even buf
byte vEP0TxBuf;           

byte ICP_USB_State;
byte ICP_Result;

dword vStartAddr;
byte vLongNumber;


typedef byte (*pCmdInRam)(byte cmd);

typedef struct {
  unsigned char code[100];              
} CmdInRam_t;

CmdInRam_t CmdInRam;
pCmdInRam FnCmdInRam;
byte result;


/********************************************************************
*********************************************************************
*     Flash subroutines
*********************************************************************
********************************************************************/


byte Flash_Cmd(byte Cmd)
{  
    FCMD = Cmd;
  
    FSTAT = 0x80;     // launch command
    
    if(FSTAT&0x30)
    {
      return 0xFF;
    }
    
    while(!FSTAT_FCCF){}
    
    
  return 0x01;
  
}

// sector erase (1k bytes)
byte Flash_Erase(dword addr)
{
    FnCmdInRam = (void*)((dword)&CmdInRam); 
    CmdInRam = *(CmdInRam_t *)(Flash_Cmd);
    FSTAT = 0x30;         
    
    *(dword *)addr = 0x55;
    
    return(FnCmdInRam(0x40));    

}


// dword(32bit) programming
byte Flash_Prog(dword flash_addr,dword data_addr,byte number)
{
   
   byte i;
   
   FnCmdInRam = (void*)((dword)&CmdInRam); 
   CmdInRam = *(CmdInRam_t *)(Flash_Cmd);
   FSTAT = 0x30; 
    
   for(i=0;i<number;i++)
   {
      *(dword *)flash_addr = *(dword *)data_addr;
      result= FnCmdInRam(0x20);
      if(result == 0xFF)
        return 0xFF;
      flash_addr +=4;
      data_addr +=4;
   }
   
   return result;
}
    

byte Flash_Verify(dword dst_addr, dword data_addr, byte length) 
{
  do
	 {
		  if(*(dword *)dst_addr != *(dword *)data_addr) // compare two values
		{
		   return 0xFF;
		}	
		
		dst_addr +=4;
		data_addr +=4; 
	}	 
	while(--length);		
    
  return 0x01;
}



/********************************************************************
*********************************************************************
*       ICP Device Descriptor
*********************************************************************
********************************************************************/
const byte ICP_DeviceDesc[18]= 
{
	0x12,		      //blength
	0x01,		      //bDescriptor
	0x02,0x00,	  //bcdUSB ver R=2.00 
	0x00,		      //bDeviceClass
	0x00,		      //bDeviceSubClass			
	0x00,		      //bDeviceProtocol			
	0x40,		      //bMaxPacketSize0
	0xA2,0x15,	  //idVendor - 0x0425 (Motorola Semi. HK Ltd.)
	0x41,0x00,	  //idProduct - Product ID=0xFF09
	0x01,0x00,	  //bcdDevice - Version 1.00
	0x00,		      //iManufacturer - Index to string descriptor
	0x00,		      //iProduct - Index to string descriptor
	0x00,		      //iSerialNumber - Index to string descriptor
	0x01	       	//bNumConfigurations - # of config. at current speed,
};




/********************************************************************
*********************************************************************
*       ICP Configuration Descriptor
*********************************************************************
********************************************************************/
const byte  ICP_ConfigDesc[25]= 
{
	0x09,		      //blength
	0x02,		      //bDescriptor
	0x19,0x00,	  //wTotalLength - # of bytes including interface and endpoint descpt.
	0x01,		      //bNumInterfaces - at least 1 data interface
	0x01,		      //bConfigurationValue - 
	0x00,		      //iConfiguration - index to string descriptor	
	0x80,		      //bmAttributes - 0x?0	bit 7-bus powered
				        //						        bit 6-self powered
				        //						        bit 5-remote wakeup
				        //						        bit 4-0-reserved
	0x32,		      //bMaxPower - 50mA
	
// ======================================================
// 		Standard Interface Descriptor
// ======================================================

	0x09,		      //blength
	0x04,		      //bDescriptorType - Interface descriptor
	0x00,		      //bInterfaceNumber - Zero based value identifying the index of the config.
	0x00,		      //bAlternateSetting;
	0x01,		      //bNumEndpoints - 1 endpoints
	0xFF,		      //bInterfaceClass 
	0x00,		      //bInterfaceSubClass 
	0xFF,		      //bInterfaceProtocol
	0x00,		      //iInterface - Index to String descriptor
	
// ======================================================
// 		Standard Endpoint Descriptor
// ======================================================
	0x07,		      //bLength;
	0x05,		      //bDescriptorType - Endpoint descriptor
	0x81,		      //bEndpointAddress - bit 3..0 endpoint number
				        // 					         bit 6..4 Reserved reset to zero
				        //					         bit 7	0-OUT, 1-IN									
	0x03,		      //bmAttributes
	0x40,0x00,	  //wMaxPacketSize - 64 byte packet size
	0xFF,		      //bInterval 
 
};


/********************************************************************
*********************************************************************
*       ICP String Descriptor
*********************************************************************
********************************************************************/
const byte ICP_StringDesc[2] = {
	0x02,         // size
	0x03,         // type
	};





/********************************************************************
*********************************************************************
*     USB subroutines
*********************************************************************
********************************************************************/

void Init_USB(void) 
{
  //byte temp;
  long *ptr;
  byte i;
  
  //temp = USBTRC0;
  
  //temp &= 0x44;
  
  
  USBTRC0_USBRESET = 1;
  while(USBTRC0_USBRESET){};
  
  ptr= (long *)0x00803E00;
  
  for(i=0; i<64;i++)
    *(ptr+i)=0;
  
    
  EP0Rx[0].BDT_Stat._byte = mUDATA0;
	EP0Rx[0].Cnt = mEP0_BUFF_SIZE;
  EP0Rx[0].Addr0 = 0x20;
  EP0Rx[0].Addr1 = 0x3E;
  EP0Rx[0].Addr2 = 0x80;
  EP0Rx[0].Addr3 = 0x00;
  
  
  EP0Rx[1].BDT_Stat._byte = mUDATA1;
	EP0Rx[1].Cnt = mEP0_BUFF_SIZE;
  EP0Rx[1].Addr0 = 0x30;
  EP0Rx[1].Addr1 = 0x3E;
  EP0Rx[1].Addr2 = 0x80;
  EP0Rx[1].Addr3 = 0x00;
  

  EP0Tx[0].BDT_Stat._byte = mUDATA0;
	EP0Tx[0].Cnt = mEP0_BUFF_SIZE;
  EP0Tx[0].Addr0 = 0x80;
  EP0Tx[0].Addr1 = 0x3E;
  EP0Tx[0].Addr2 = 0x80;
  EP0Tx[0].Addr3 = 0x00;
  
  
  EP0Tx[1].BDT_Stat._byte = mUDATA1;
	EP0Tx[1].Cnt = mEP0_BUFF_SIZE;
  EP0Tx[1].Addr0 = 0x80;
  EP0Tx[1].Addr1 = 0x3E;
  EP0Tx[1].Addr2 = 0x80;
  EP0Tx[1].Addr3 = 0x00;
  

  USB_CTRL = 0x03;              // system clock
  
  BDT_PAGE_01 = 0x3E;           // BDT from 0x00803E00
  BDT_PAGE_02 = 0x80;
  BDT_PAGE_03 = 0x00;
  
  
  ENDPT0 = 0x0D;                // enable endpoint  
  
  INT_ENB = 0x00;               // disable all interrupt
  OTG_INT_EN = 0x00;            // disable all OTG interrupt
  ERR_ENB = 0x00;               // disable all error interrupt
  INT_STAT = 0xFF;
  
  USB_OTG_CONTROL_DPPULLUP_NONOTG = 1;
  
  CTL = 0x01;                   // USB module enable
  
  USBTRC0 = USB_CONFIG;         //0x44;// enable USB vreg and pullup resistor
  
  
}
  


void EP0_Load(void)
{    
    
    byte *pDst;
    
    if(vEP0IN_DataCnt==0)
      return;
                  
    pDst=(byte *)&ICP_IN_Data;
    
    
    EP0Tx[vEP0TxBuf].Cnt = vEP0IN_DataCnt;
   
 
    while(vEP0IN_DataCnt)
    {
       *pDst = *pEP0IN_Data;
       pDst++;
       pEP0IN_Data++;
       vEP0IN_DataCnt--;
    }
    
    EP0Tx[vEP0TxBuf].BDT_Stat._byte = vEP0TxData;
    vEP0TxData ^=0x40;
    vEP0TxBuf ^=0x01;
      
}     


void ICP_USB_Wait(void)
{
            
    CTL_ODD_RST = 1; 
    
    vEP0RxBuf = 0;
    vEP0TxBuf = 0;
    vEP0RxData = mUDATA0;
    vEP0TxData = mUDATA0;
    
    CTL_ODD_RST = 0;
      
    EP0Rx[0].BDT_Stat._byte = mUDATA0;
	  EP0Rx[0].Cnt = mEP0_BUFF_SIZE;
	  
	  EP0Rx[1].BDT_Stat._byte = mMCU;
	  EP0Rx[1].Cnt = mEP0_BUFF_SIZE;
   
    EP0Tx[0].BDT_Stat._byte = mMCU;
	  EP0Tx[0].Cnt = mEP0_BUFF_SIZE;
	  EP0Tx[1].BDT_Stat._byte = mMCU;
	  EP0Tx[1].Cnt = mEP0_BUFF_SIZE;
   
    
    CTL_TXSUSPEND_TOKENBUSY = 0; 
    
    ICP_USB_State = mICP_WAIT;              
   
}

void ICP_Setup_Handler(void)
{
   byte length;
   //byte i;
   
   vEP0IN_DataCnt= 0;
   ICP_USB_State = mICP_WAIT;
   
   switch(Setup_Pkt.bRequest) 
   {
     
      case mGET_STATUS:
        pEP0IN_Data = (byte*)&ICP_DeviceDesc+4; 			
        vEP0IN_DataCnt = 0x02;   
        break;
      
      case mSET_ADDR:
        ICP_AddrPend = 1;
        break;
      
      case mGET_DESC:
        
        switch(Setup_Pkt.wValue_h) 
        {
          case mDESC_DEV:
            pEP0IN_Data = (byte*)&ICP_DeviceDesc;
            vEP0IN_DataCnt = sizeof(ICP_DeviceDesc);
            break;
          
          case mDESC_CFG:
            pEP0IN_Data = (byte*)&ICP_ConfigDesc;
            vEP0IN_DataCnt = sizeof(ICP_ConfigDesc);
            break;
        
          case mDESC_STR:
            pEP0IN_Data = (byte*)&ICP_StringDesc;
            vEP0IN_DataCnt = 2;
            break;
          
          default: 
            break;  
        }
        
        break;
      
      case mSET_CFG:
        break;
      
      
      case mPROGRAM:
			  vStartAddr = *(dword *)&Setup_Pkt.wValue_l;
			  vLongNumber = (byte)(Setup_Pkt.wLength_l);
			  ICP_Prog=1;
	      ICP_Result = 0;
			  break;
      
      case mSECTOR_ERASE:
			  vStartAddr = *(dword *)&Setup_Pkt.wValue_l;
			  //vStartAddr = 0x1000;
			  ICP_Result = 0;
			  ICP_Result=Flash_Erase(vStartAddr);
			  asm (nop);
	
			  break;
			  
      case mVERIFY:
        vStartAddr = *(dword *)&Setup_Pkt.wValue_l;
        vLongNumber = (byte)(Setup_Pkt.wLength_l);
        ICP_Verify=1;
	      ICP_Result = 0;
        break;
			  
      case mGET_RESULT:
        pEP0IN_Data = (byte*)&ICP_Result;
        vEP0IN_DataCnt = 1;
        break;  
     
      
      default:                         // not support
        break;
          
   }

   if(Setup_Pkt.bmRequestType &0x80)              // Device to Host
    {
       
       length = Setup_Pkt.wLength_l;
              
  		 if(length < vEP0IN_DataCnt)
         vEP0IN_DataCnt = length;
  			
       vEP0TxData = mUDATA1; 
       EP0_Load();
       ICP_USB_State   = mICP_TX; 
      
    }
    else    
    {
       ICP_USB_State   = mICP_RX;
       EP0Tx[vEP0TxBuf].Cnt = 0x00;                              // return zero IN data
       EP0Tx[vEP0TxBuf].BDT_Stat._byte = mUDATA1;  
    }
  
         
 	 vEP0RxData ^= 0x40;
	 vEP0RxBuf ^= 0x01;
	 EP0Rx[vEP0RxBuf].Cnt = mEP0_BUFF_SIZE;
         
   EP0Rx[vEP0RxBuf].BDT_Stat._byte = vEP0RxData; 
   CTL_TXSUSPEND_TOKENBUSY = 0;
 
}


 void ICP_In_Handler(void)
{
   
    if(ICP_AddrPend ==1) {
        ADDR = Setup_Pkt.wValue_l;
        ICP_AddrPend =0;
    }
           
    if(ICP_USB_State == mICP_TX)
    {
      EP0_Load();
    } 
    
    else
      ICP_USB_Wait(); 
}


void ICP_Out_Handler(void)
{
   byte Len;
    
   Len=EP0Rx[vEP0RxBuf].Cnt;
  
   if(ICP_USB_State==mICP_RX)
   {
   
     if(ICP_Prog==1 && Len==vLongNumber)  
     {
         vLongNumber>>=2; 
         ICP_Result=Flash_Prog(vStartAddr, (dword)&ICP_OUT_Data,vLongNumber);//Setup_Pkt,vLongNumber); 
         ICP_Prog=0;
      }
          
        
     if( ICP_Verify==1 && Len==vLongNumber)  
     {         
         vLongNumber >>=2;
         ICP_Result= Flash_Verify(vStartAddr, (unsigned int)&ICP_OUT_Data,vLongNumber); 
         ICP_Verify =0;
         
      }
        
    
    
    vEP0RxData ^=0x40;
    vEP0RxBuf ^=0x01;
    
  } 
  else
    ICP_USB_Wait();  
}



void ICP_Reset_Handler(void)
{
 
   INT_STAT = 0xFF;              // clear all flag
   INT_ENB = 0x00;
   ADDR = 0x00;
   ICP_USB_Wait();   
    
}



void Bootloader_Main(void) 
{
   byte stat;
   byte odd; 
   
   asm (move.w  #0x2700,sr);    // disable interrupt
   asm (move.l  #0x801FF0,a7);  // initialize stack pointer
  
   //clear ram
   ICP_VAR = 0x00;
   ICP_Result = 0x00;
   vEP0IN_DataCnt = 0x00;
   vEP0RxData = 0x00;          
   vEP0TxData = 0x00;          
   vEP0RxBuf = 0x00;           
   vEP0TxBuf = 0x00;           
   vStartAddr = 0;
   vLongNumber = 0;;
   
   FCDIV=0x4F;               // for bus clock=24MHz 
   //asm (nop);
   
   //Flash_Prog( (dword)0xFF0,(dword)0x800400,1);
   
   //asm (nop);
   //for(;;)
   //{
   //};
   
   Init_USB();
   
   for(;;)
   {
    
    if(INT_STAT_USB_RST)
     {
       ICP_Reset_Handler();
     }
    
    
    if(INT_STAT_TOK_DNE)
    {
        stat=(byte)(STAT &0xF8);
 			  odd = STAT_ODD;
         
        // OUT or SETUP token
        if(stat == mEP0_OUT)
        {
          // SETUP token
          if(EP0Rx[odd].BDT_Stat.RecPid.PID == mSETUP_TOKEN)
          {
            ICP_Setup_Handler();
            asm (nop); 
          }  
          // OUT token
          else                                              
            ICP_Out_Handler();
        }
        
        else if(stat == mEP0_IN)
        {
          // IN token                                 
           ICP_In_Handler();
        }
      
      // Clear token flag  
      INT_STAT_TOK_DNE = 1;    
    }
    
   }// for end

}






